/*
 * Defines for IEEE Standard 695-1990 Format Symbol Tables.
 * Used by the Microtek Research Inc. (MRI) 68k cross compiler.
 *
 * Author: D. A. Kapilow
 * Date: 6/4/92
 */
#define	CMD_MB	0xE0
#define	CMD_ME	0xE1
#define	CMD_AS	0xE2
#define	CMD_IR	0xE3
#define	CMD_LR	0xE4
#define	CMD_SB	0xE5
#define	CMD_ST	0xE6
#define	CMD_SA	0xE7
#define	CMD_NI	0xE8
#define	CMD_NX	0xE9
#define	CMD_CO	0xEA
#define	CMD_DT	0xEB
#define	CMD_AD	0xEC
#define	CMD_LD	0xED
#define	CMD_Cs	0xEE
#define	CMD_CS	0xEF
#define	CMD_NN	0xF0
#define	CMD_AT	0xF1
#define	CMD_TY	0xF2
#define	CMD_RI	0xF3
#define	CMD_WX	0xF4
#define	CMD_LI	0xF5
#define	CMD_LX	0xF6
#define	CMD_RE	0xF7
#define	CMD_BS	0xF8	/* 0xF7 is last one defined in the IEEE std. */
#define	CMD_BE	0xF9

#define STVAR_A	0xC1
#define STVAR_B	0xC2
#define STVAR_C	0xC3
#define STVAR_D	0xC4
#define STVAR_E	0xC5
#define STVAR_F	0xC6
#define STVAR_G	0xC7
#define STVAR_H	0xC8
#define STVAR_I	0xC9
#define STVAR_J	0xCA
#define STVAR_K	0xCB
#define STVAR_L	0xCC
#define STVAR_M	0xCD
#define STVAR_N	0xCE
#define STVAR_O	0xCF
#define STVAR_P	0xD0
#define STVAR_Q	0xD1
#define STVAR_R	0xD2
#define STVAR_S	0xD3
#define STVAR_T	0xD4
#define STVAR_U	0xD5
#define STVAR_V	0xD6
#define STVAR_W	0xD7
#define STVAR_X	0xD8
#define STVAR_Y	0xD9
#define STVAR_Z	0xDA

#define	FUNC_FALSE	0xA0
#define	FUNC_TRUE	0xA1
#define	FUNC_ABS	0xA2
#define	FUNC_NEG	0xA3
#define	FUNC_NOT	0xA4
#define	FUNC_PLUS	0xA5
#define	FUNC_MINUS	0xA6
#define	FUNC_DIV	0xA7
#define	FUNC_MUL	0xA8
#define	FUNC_MAX	0xA9
#define	FUNC_MIN	0xAA
#define	FUNC_MOD	0xAB
#define	FUNC_LESS	0xAC
#define	FUNC_GT		0xAD
#define	FUNC_EQ		0xAE
#define	FUNC_PND	0xAF
#define	FUNC_AND	0xB0
#define	FUNC_OR		0xB1
#define	FUNC_XOR	0xB2
#define	FUNC_EXT	0xB3
#define	FUNC_INS	0xB4
#define	FUNC_ERR	0xB5
#define	FUNC_IF		0xB6
#define	FUNC_ELSE	0xB7
#define	FUNC_END	0xB8
#define	FUNC_ISDEF	0xB9
#define	FUNC_LP		0xBE
#define	FUNC_RP		0xBF

/*
 * Microtek block type for for CMD_BS
*/
#define	BLK_TYPES	0x01	/* Type info table */
#define	BLK_DECL	0x03	/* Declarations, includes functins */
#define	BLK_FUNC	0x04	/* Function */
#define	BLK_LINFO	0x05	/* Line numbers */
#define	BLK_SCOPE	0x06	/* Scope info */
#define	BLK_FINFO	0x0A	/* File info */
#define	BLK_SINFO	0x0B	/* Section info */
